function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 107);

T = GK_financial.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(53) = (-1);
T(54) = T(4)^(-params(6))*T(2);
T(55) = (1-params(6))*T(2)*params(7)/T(6);
T(56) = (-(params(7)/T(4)));
T(57) = getPowerDeriv(T(8),1-params(6),1);
T(58) = T(4)*(-y(25))/(y(1)*y(1));
T(59) = (T(4)*y(96)-y(25)*params(7))*(T(4)*y(96)-y(25)*params(7));
T(60) = T(4)*1/y(1);
T(61) = (params(6)-1)*getPowerDeriv(y(26),1+params(35),1)/(1+params(35));
T(62) = T(10)*T(61);
T(63) = getPowerDeriv(y(26),params(35),1);
T(64) = 1/T(4);
T(65) = T(64)*getPowerDeriv(T(27),1-params(2),1);
T(66) = T(4)*(-y(30))/(y(3)*y(3));
T(67) = T(4)*1/y(3);
T(68) = (-(T(54)*y(100)))/(y(33)*y(33));
T(69) = T(54)/y(33);
T(70) = 1/(steady_state(18));
T(71) = getPowerDeriv(y(8),params(13),1);
T(72) = T(71)/y(41);
T(73) = getPowerDeriv(T(23),1-params(5),1);
T(74) = getPowerDeriv(y(8),params(5)*params(13),1);
T(75) = (-(T(24)*T(74)));
T(76) = getPowerDeriv(y(8),params(12),1);
T(77) = T(76)/y(40);
T(78) = getPowerDeriv(T(38),1-params(4),1);
T(79) = getPowerDeriv(y(8),params(4)*params(12),1);
T(80) = (-(T(39)*T(79)));
T(81) = getPowerDeriv(y(40),params(5)*params(13),1);
T(82) = (-(T(16)*T(81)));
T(83) = T(82)/(T(17)*T(17));
T(84) = getPowerDeriv(y(40),params(13)*(params(5)-1),1);
T(85) = y(103)*T(84);
T(86) = (-(T(16)*T(85)));
T(87) = T(86)/(T(20)*T(20));
T(88) = getPowerDeriv(y(40),params(4)*params(12),1);
T(89) = (-(T(31)*T(88)));
T(90) = T(89)/(T(32)*T(32));
T(91) = getPowerDeriv(y(40),params(12)*(params(4)-1),1);
T(92) = (-(T(34)*T(91)));
T(93) = T(92)/(T(35)*T(35));
T(94) = getPowerDeriv(y(40),params(4),1);
T(95) = (-(T(16)*T(19)))/(T(20)*T(20));
T(96) = getPowerDeriv(y(103),params(4),1);
T(97) = T(96)/T(32);
T(98) = getPowerDeriv(y(103),params(4)-1,1);
T(99) = T(98)/T(35);
T(100) = getPowerDeriv(y(41),params(5),1);
T(101) = getPowerDeriv(y(104),params(5),1);
T(102) = T(4)*(-y(42))/(y(9)*y(9));
T(103) = T(4)*1/y(9);
T(104) = getPowerDeriv(y(44)*y(50),params(2),1);
T(105) = (-y(54))/(y(13)*y(13));
T(106) = 1/y(13);
T(107) = (y(71)-(y(72)+y(69)*y(73)))*(y(71)-(y(72)+y(69)*y(73)));

end
